function res = mem(u,param)
% ------------------------------------------------------------
% MEM
% Laplace transformed memory function $\tilde{M}(u)-n$
% for the TPL  model. 
% 
% Modified by Shidong Jiang on July 16, 2017.
%
% RES = MEM(U,PARAM)
%
% u     := Laplace variable
% param := parameters of the psi function
% res   := values of the function $\tilde(M)(u)$
% 
% Usage example:
% y = MEM(1+i,[1 0.05 0.75])
%
% ------------------------------------------------------------
    beta    = param(1); 
    t1      = param(2); t1 = 10^t1;
    t2      = param(3); t2 = 10^t2;

    if (beta<0 || t1<0 || t2<0), 
      res = NaN; 
    end

    if t2 > t1
      tchar = t1;  
      mu   = t1 .* u;    
      tau2i= t1 ./ t2;
      x =  tau2i + mu;
      n =1./ (  tau2i.^beta .* exp(tau2i) .* igamma(-beta, tau2i)  );

      psi = n .* x.^beta .* exp(x) .* igamma(-beta,x);

% subtract the limiting value n --- modified by Shidong Jiang on
% July 16, 2017
      res = tchar*psi./(1-psi).*u - n; 
% Modified by Shidong Jiang on July 16, 2017      
      ind = find(abs(u)<1e-9);
      res(ind) = 1/(-1+(n-beta)/tau2i) - n; % function value at u=0
    else
      res = NaN;
    end 
end    
